//
// LocalSolver Model for Clustering
//

use io;

function input() 
{

  usage = "\nUsage: localsolver clustering.lsp "
        + "fileName=dataFile k=numberOfClusters[lsTimeLimit=timeLimit]\n";

  if (fileName == nil) error(usage);
  dataFile = openRead(fileName + ".dat");
  n = dataFile.readInt(); // number of elements
  d = dataFile.readInt(); // number of attributes
  a[i in 1..n][j in 1..d] <- dataFile.readDouble();
  close(dataFile);

}

function model()
{
  // x[i][l] = 1 if element i is assigned to cluster l
  x[i in 1..n][l in 1..k] <- bool();
  
  // elements should be assigned to only one cluster
  for[i in 1..n] 
    constraint sum[l in 1..k] (x[i][l]) == 1;

  // there should be exactly k clusters
  for[l in 1..k] 
    constraint sum[i in 1..n] (x[i][l]) >= 1;

  // calculate centroids
  c[l in 1..k][j in 1..d] <- (sum[i in 1..n] (x[i][l]*a[i][j])) / sum[i in 1..n] (x[i][l]);

  // objective function
  obj <- sum[l in 1..k][i in 1..n] (x[i][l] * sum[j in 1..d] (pow(a[i][j]-c[l][j], 2)));
  minimize obj;
}

function output() 
{
  // write output file
  outputFile = openWrite(fileName + ".out");
  for[i in 1..n]
    for[l in 1..k]
      if (getValue(x[i][l]) == 1) outputFile.println(l);
  close(outputFile);
}